/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBBitString;
import io.github.pmctools.umbj.UMBException;
import io.github.pmctools.umbj.UMBIndex;
import io.github.pmctools.umbj.UMBType;
import java.util.ArrayList;
import java.util.List;

public class UMBBitPacking {
    private final List<BitPackedItem> items = new ArrayList<BitPackedItem>();
    private final List<Integer> itemOffsets = new ArrayList<Integer>();
    private final List<Integer> varIndices = new ArrayList<Integer>();
    private int totalNumBits = 0;

    public UMBBitPacking(UMBIndex.ValuationClassDescription valuationClassDescription) {
        for (UMBIndex.ValuationVariable valuationVariable : valuationClassDescription.variables) {
            if (valuationVariable.isVariable()) {
                this.addVariable(valuationVariable.name, valuationVariable.type);
                continue;
            }
            if (!valuationVariable.isPadding()) continue;
            this.addPadding(valuationVariable.padding);
        }
    }

    public UMBBitPacking() {
    }

    public void addVariable(String string, UMBType uMBType) {
        this.addItem(new BitPackedVariable(string, uMBType));
        this.varIndices.add(this.items.size() - 1);
    }

    public void addPadding(int n) {
        this.addItem(new BitPackedPadding(n));
    }

    private void addItem(BitPackedItem bitPackedItem) {
        if (this.items.isEmpty()) {
            this.itemOffsets.add(0);
        } else {
            this.itemOffsets.add(this.itemOffsets.get(this.itemOffsets.size() - 1) + this.items.get((int)(this.items.size() - 1)).size);
        }
        this.items.add(bitPackedItem);
        this.totalNumBits += bitPackedItem.size;
    }

    public void padToByteBoundary() {
        if (this.getTotalNumBits() % 8 != 0) {
            this.addPadding(8 - this.getTotalNumBits() % 8);
        }
    }

    public UMBIndex.ValuationClassDescription toValuationClassDescription() {
        UMBIndex.ValuationClassDescription valuationClassDescription = new UMBIndex.ValuationClassDescription();
        int n = this.getNumItems();
        for (int i = 0; i < n; ++i) {
            BitPackedItem bitPackedItem = this.getItem(i);
            UMBIndex.ValuationVariable valuationVariable = new UMBIndex.ValuationVariable();
            if (bitPackedItem instanceof BitPackedVariable) {
                BitPackedVariable bitPackedVariable = (BitPackedVariable)bitPackedItem;
                valuationVariable.name = bitPackedVariable.name;
                valuationVariable.type = bitPackedVariable.type;
            } else if (bitPackedItem instanceof BitPackedPadding) {
                valuationVariable.padding = bitPackedItem.size;
            }
            valuationClassDescription.variables.add(valuationVariable);
        }
        if (this.getTotalNumBits() % 8 != 0) {
            UMBIndex.ValuationVariable valuationVariable = new UMBIndex.ValuationVariable();
            valuationVariable.padding = 8 - this.getTotalNumBits() % 8;
            valuationClassDescription.variables.add(valuationVariable);
        }
        return valuationClassDescription;
    }

    public int getNumItems() {
        return this.items.size();
    }

    public BitPackedItem getItem(int n) {
        return this.items.get(n);
    }

    public int getItemOffset(int n) {
        return this.itemOffsets.get(n);
    }

    public int getItemSize(int n) {
        return this.getItem((int)n).size;
    }

    public int getTotalNumBits() {
        return this.totalNumBits;
    }

    public int getTotalNumBytes() {
        int n = this.totalNumBits;
        if (n % 8 != 0) {
            n += 8 - n % 8;
        }
        return n / 8;
    }

    public int getNumVariables() {
        return this.varIndices.size();
    }

    public BitPackedVariable getVariable(int n) {
        return (BitPackedVariable)this.items.get(this.varIndices.get(n));
    }

    public int getVariableOffset(int n) {
        return this.itemOffsets.get(this.varIndices.get(n));
    }

    public int getVariableSize(int n) {
        return this.getVariable((int)n).size;
    }

    public UMBBitString newBitString() {
        return new UMBBitString(this.getTotalNumBytes());
    }

    public void setIntVariableValue(UMBBitString uMBBitString, int n, int n2) throws UMBException {
        uMBBitString.setInt(this.getVariableOffset(n), this.getVariableSize(n), n2);
    }

    public void setUIntVariableValue(UMBBitString uMBBitString, int n, int n2) throws UMBException {
        uMBBitString.setUInt(this.getVariableOffset(n), this.getVariableSize(n), n2);
    }

    public void setDoubleVariableValue(UMBBitString uMBBitString, int n, double d) throws UMBException {
        uMBBitString.setDouble(this.getVariableOffset(n), this.getVariableSize(n), d);
    }

    public void setBooleanVariableValue(UMBBitString uMBBitString, int n, boolean bl) throws UMBException {
        uMBBitString.setBoolean(this.getVariableOffset(n), this.getVariableSize(n), bl);
    }

    public Object getVariableValue(UMBBitString uMBBitString, int n) throws UMBException {
        BitPackedVariable bitPackedVariable = this.getVariable(n);
        switch (bitPackedVariable.getType().type) {
            case BOOL: {
                return this.getBooleanVariableValue(uMBBitString, n);
            }
            case INT: {
                return this.getIntVariableValue(uMBBitString, n);
            }
            case UINT: {
                return this.getUIntVariableValue(uMBBitString, n);
            }
            case DOUBLE: {
                return this.getDoubleVariableValue(uMBBitString, n);
            }
        }
        throw new UMBException("Unknown variable type: " + String.valueOf(bitPackedVariable.getType().type));
    }

    public int getIntVariableValue(UMBBitString uMBBitString, int n) throws UMBException {
        return uMBBitString.getInt(this.getVariableOffset(n), this.getVariableSize(n));
    }

    public int getUIntVariableValue(UMBBitString uMBBitString, int n) throws UMBException {
        return uMBBitString.getUInt(this.getVariableOffset(n), this.getVariableSize(n));
    }

    public double getDoubleVariableValue(UMBBitString uMBBitString, int n) throws UMBException {
        return uMBBitString.getDouble(this.getVariableOffset(n), this.getVariableSize(n));
    }

    public boolean getBooleanVariableValue(UMBBitString uMBBitString, int n) throws UMBException {
        return uMBBitString.getBoolean(this.getVariableOffset(n), this.getVariableSize(n));
    }

    public String decodeBitString(UMBBitString uMBBitString) throws UMBException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        int n = this.getNumVariables();
        for (int i = 0; i < n; ++i) {
            BitPackedVariable bitPackedVariable = this.getVariable(i);
            int n2 = this.getVariableOffset(i);
            int n3 = this.getVariableSize(i);
            switch (bitPackedVariable.getType().type) {
                case BOOL: {
                    stringBuilder.append(uMBBitString.getBoolean(n2, n3));
                    break;
                }
                case INT: {
                    stringBuilder.append(uMBBitString.getInt(n2, n3));
                    break;
                }
                case UINT: {
                    stringBuilder.append(uMBBitString.getUInt(n2, n3));
                    break;
                }
                case DOUBLE: {
                    stringBuilder.append(uMBBitString.getDouble(n2, n3));
                    break;
                }
                default: {
                    throw new UMBException("Unknown variable type: " + String.valueOf(bitPackedVariable.type));
                }
            }
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String formatBitString(UMBBitString uMBBitString) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getNumItems();
        for (int i = n - 1; i >= 0; --i) {
            BitPackedItem bitPackedItem = this.getItem(i);
            int n2 = this.getItemOffset(i);
            int n3 = this.getItemSize(i);
            if (bitPackedItem instanceof BitPackedVariable) {
                stringBuilder.append(uMBBitString.toString(n2, n3));
            } else if (bitPackedItem instanceof BitPackedPadding) {
                for (int j = 0; j < n3; ++j) {
                    stringBuilder.append(".");
                }
            }
            if (i <= 0) continue;
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }

    public static class BitPackedVariable
    extends BitPackedItem {
        public String name;
        private UMBType type;

        public BitPackedVariable(String string, UMBType uMBType) {
            this.name = string;
            this.setType(uMBType);
        }

        public void setType(UMBType uMBType) {
            this.type = uMBType;
            this.size = uMBType.size;
        }

        public UMBType getType() {
            return this.type;
        }
    }

    public static class BitPackedItem {
        public int size;
    }

    public static class BitPackedPadding
    extends BitPackedItem {
        public BitPackedPadding(int n) {
            this.size = n;
        }
    }
}

