/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.iterable.Reducible;
import common.iterable.SingletonIterator;
import explicit.DTMC;
import explicit.modelviews.DTMCView;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import parser.State;
import parser.Values;
import parser.VarList;

public class DTMCAlteredDistributions<Value>
extends DTMCView<Value> {
    private DTMC<Value> model;
    private IntFunction<Iterator<Map.Entry<Integer, Value>>> mapping;
    private Predicate<Map.Entry<Integer, Value>> nonZero;

    public DTMCAlteredDistributions(DTMC<Value> dTMC, IntFunction<Iterator<Map.Entry<Integer, Value>>> intFunction) {
        this.model = dTMC;
        this.mapping = intFunction;
        this.nonZero = entry -> dTMC.getEvaluator().gt(entry.getValue(), dTMC.getEvaluator().zero());
    }

    public DTMCAlteredDistributions(DTMCAlteredDistributions<Value> dTMCAlteredDistributions) {
        super(dTMCAlteredDistributions);
        this.model = dTMCAlteredDistributions.model;
        this.mapping = dTMCAlteredDistributions.mapping;
        this.nonZero = entry -> this.model.getEvaluator().gt(entry.getValue(), this.model.getEvaluator().zero());
    }

    public DTMCAlteredDistributions<Value> clone() {
        return new DTMCAlteredDistributions<Value>(this);
    }

    @Override
    public int getNumStates() {
        return this.model.getNumStates();
    }

    @Override
    public int getNumInitialStates() {
        return this.model.getNumInitialStates();
    }

    @Override
    public Iterable<Integer> getInitialStates() {
        return this.model.getInitialStates();
    }

    @Override
    public int getFirstInitialState() {
        return this.model.getFirstInitialState();
    }

    @Override
    public boolean isInitialState(int n) {
        return this.model.isInitialState(n);
    }

    @Override
    public List<State> getStatesList() {
        return this.model.getStatesList();
    }

    @Override
    public VarList getVarList() {
        return this.model.getVarList();
    }

    @Override
    public Values getConstantValues() {
        return this.model.getConstantValues();
    }

    @Override
    public BitSet getLabelStates(String string) {
        return this.model.getLabelStates(string);
    }

    @Override
    public Set<String> getLabels() {
        return this.model.getLabels();
    }

    @Override
    public boolean hasLabel(String string) {
        return this.model.hasLabel(string);
    }

    @Override
    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int n) {
        Iterator<Map.Entry<Integer, Value>> iterator = this.mapping.apply(n);
        if (iterator == null) {
            return this.model.getTransitionsIterator(n);
        }
        return Reducible.extend(iterator).filter((Predicate)this.nonZero);
    }

    @Override
    protected void fixDeadlocks() {
        assert (!this.fixedDeadlocks) : "deadlocks already fixed";
        this.model = DTMCAlteredDistributions.fixDeadlocks(this.clone());
        this.mapping = n -> null;
    }

    public static <Value> DTMCAlteredDistributions<Value> fixDeadlocks(DTMC<Value> dTMC) {
        BitSet bitSet = new BitSet();
        dTMC.getDeadlockStates().forEach(bitSet::set);
        DTMCAlteredDistributions<Value> dTMCAlteredDistributions = DTMCAlteredDistributions.addSelfLoops(dTMC, bitSet);
        dTMCAlteredDistributions.deadlockStates = bitSet;
        dTMCAlteredDistributions.fixedDeadlocks = true;
        return dTMCAlteredDistributions;
    }

    public static <Value> DTMCAlteredDistributions<Value> addSelfLoops(final DTMC<Value> dTMC, final BitSet bitSet) {
        IntFunction intFunction = new IntFunction<Iterator<Map.Entry<Integer, Value>>>(){

            @Override
            public Iterator<Map.Entry<Integer, Value>> apply(int n) {
                if (bitSet.get(n)) {
                    AbstractMap.SimpleImmutableEntry simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry(n, dTMC.getEvaluator().one());
                    return new SingletonIterator.Of(simpleImmutableEntry);
                }
                return null;
            }
        };
        return new DTMCAlteredDistributions<Value>(dTMC, intFunction);
    }
}

