/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.CTMCSimple;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.IDTMCSimple;
import explicit.IMDPSimple;
import explicit.MDP;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.POMDPSimple;
import explicit.STPGSimple;
import io.ExplicitModelImporter;
import io.PrismExplicitImporter;
import java.io.File;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import parser.State;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismException;
import prism.PrismNotSupportedException;

public interface ModelSimple<Value>
extends Model<Value> {
    public void addInitialState(int var1);

    default public void buildFromExplicitImport(ExplicitModelImporter explicitModelImporter) throws PrismException {
        throw new PrismException("Explicit model not yet supported for this model");
    }

    default public void buildFromPrismExplicit(String string) throws PrismException {
        PrismExplicitImporter prismExplicitImporter = new PrismExplicitImporter(null, new File(string), null, null, null, ModelType.DTMC);
        this.buildFromExplicitImport(prismExplicitImporter);
    }

    public void clearState(int var1);

    public int addState();

    public void addStates(int var1);

    public void setStatesList(List<State> var1);

    public void addLabel(String var1, BitSet var2);

    public static ModelSimple<?> forModelType(ModelType modelType) throws PrismException {
        ModelExplicit modelExplicit = null;
        switch (modelType) {
            case DTMC: {
                modelExplicit = new DTMCSimple();
                break;
            }
            case MDP: {
                modelExplicit = new MDPSimple();
                break;
            }
            case POMDP: {
                modelExplicit = new POMDPSimple();
                break;
            }
            case IDTMC: {
                modelExplicit = new IDTMCSimple();
                break;
            }
            case IMDP: {
                modelExplicit = new IMDPSimple();
                break;
            }
            case STPG: {
                modelExplicit = new STPGSimple();
                break;
            }
            default: {
                throw new PrismNotSupportedException("Model construction not supported for " + String.valueOf((Object)modelType) + "s");
            }
        }
        return modelExplicit;
    }

    public static <V> ModelSimple<V> copy(Model<V> model) throws PrismException {
        ModelType modelType = model.getModelType();
        switch (modelType) {
            case DTMC: {
                return new DTMCSimple((DTMC)model);
            }
            case CTMC: {
                return new DTMCSimple((CTMC)model);
            }
            case MDP: {
                return new MDPSimple((MDP)model);
            }
        }
        throw new PrismNotSupportedException("Model copy not supported for " + String.valueOf((Object)modelType) + "s");
    }

    public static <V> ModelSimple<V> copy(Model<V> model, Function<? super V, ? extends V> function) throws PrismException {
        ModelType modelType = model.getModelType();
        switch (modelType) {
            case DTMC: {
                return new DTMCSimple<V>((DTMC)model, function);
            }
            case CTMC: {
                return new CTMCSimple<V>((CTMC)model, function);
            }
            case MDP: {
                return new MDPSimple<V>((MDP)model, function);
            }
        }
        throw new PrismNotSupportedException("Model copy not supported for " + String.valueOf((Object)modelType) + "s");
    }

    public static <V, V2> ModelSimple<V2> copy(Model<V> model, Function<? super V, ? extends V2> function, Evaluator<V2> evaluator) throws PrismException {
        ModelType modelType = model.getModelType();
        switch (modelType) {
            case DTMC: {
                return new DTMCSimple<V2>((DTMC)model, function, evaluator);
            }
            case CTMC: {
                return new CTMCSimple<V2>((CTMC)model, function, evaluator);
            }
            case MDP: {
                return new MDPSimple<V2>((MDP)model, function, evaluator);
            }
        }
        throw new PrismNotSupportedException("Model copy not supported for " + String.valueOf((Object)modelType) + "s");
    }
}

