/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Power;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeModLongTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    int rl = 3;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.25f;
    String[] vars;
    String[] cvars;
    String[] c1vars;
    String[] rvars;
    ModLongRing fac;
    GreatestCommonDivisorAbstract<ModLong> ufd;
    SquarefreeFiniteFieldCharP<ModLong> sqf;
    GenPolynomialRing<ModLong> dfac;
    GenPolynomial<ModLong> a;
    GenPolynomial<ModLong> b;
    GenPolynomial<ModLong> c;
    GenPolynomial<ModLong> d;
    GenPolynomial<ModLong> e;
    GenPolynomialRing<ModLong> cfac;
    GenPolynomialRing<GenPolynomial<ModLong>> rfac;
    GenPolynomial<GenPolynomial<ModLong>> ar;
    GenPolynomial<GenPolynomial<ModLong>> br;
    GenPolynomial<GenPolynomial<ModLong>> cr;
    GenPolynomial<GenPolynomial<ModLong>> dr;
    GenPolynomial<GenPolynomial<ModLong>> er;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SquarefreeModLongTest.suite());
        ComputerThreads.terminate();
    }

    public SquarefreeModLongTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SquarefreeModLongTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.vars = ExpVector.STDVARS(this.rl);
        this.cvars = ExpVector.STDVARS(this.rl - 1);
        this.c1vars = new String[]{this.cvars[0]};
        this.rvars = new String[]{this.vars[this.rl - 1]};
        this.fac = new ModLongRing(11L);
        this.ufd = GCDFactory.getProxy(this.fac);
        this.sqf = new SquarefreeFiniteFieldCharP<ModLong>(this.fac);
        SquarefreeAbstract<ModLong> squarefreeAbstract = SquarefreeFactory.getImplementation(this.fac);
        SquarefreeModLongTest.assertEquals((String)"sqf == sqff ", this.sqf.getClass(), squarefreeAbstract.getClass());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    public void testBaseSquarefree() {
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
        SquarefreeModLongTest.assertTrue((String)("squarefree(abc) | squarefree(aabbbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sortedMap = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeModLongTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sortedMap));
    }

    public void testRecursiveSquarefree() {
        this.cfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<ModLong>)this.ar).multiply(this.br).multiply(this.br);
        this.cr = this.ar.multiply((GenPolynomial<ModLong>)this.br);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        SquarefreeModLongTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactors() {
        this.cfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<ModLong>)this.cr).multiply(this.br).multiply(this.br);
        SortedMap sortedMap = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeModLongTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sortedMap));
    }

    public void testSquarefree() {
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
        SquarefreeModLongTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sortedMap = this.sqf.squarefreeFactors((ModLong)((Object)this.d));
        SquarefreeModLongTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sortedMap));
    }

    public void testBaseSquarefreeCharRoot() {
        long l = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 2, this.el + 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll + 2, this.el + 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(Power.positivePower(this.b, l)).multiply(this.c);
        this.c = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
        SquarefreeModLongTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactorsCharRoot() {
        long l = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 2, this.el + 3, this.q);
        this.b = this.dfac.random(this.kl, this.ll + 2, this.el + 3, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(Power.positivePower(this.b, l)).multiply(this.c);
        SortedMap sortedMap = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeModLongTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sortedMap));
    }

    public void testRecursiveSquarefreeCharRoot() {
        long l = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, this.ll, this.el + 1, this.q).monic();
        this.br = this.rfac.random(this.kl, this.ll, this.el + 1, this.q).monic();
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q).monic();
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<ModLong>)this.ar).multiply(Power.positivePower(this.br, l));
        this.cr = this.ar.multiply((GenPolynomial<ModLong>)this.ar).multiply(this.br);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursiveSparsePseudoRemainder(this.dr, this.cr);
        SquarefreeModLongTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactorsCharRoot() {
        long l = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<ModLong>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<ModLong>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q).monic();
        this.br = this.rfac.random(this.kl, 3, 3, this.q).monic();
        this.cr = this.rfac.random(this.kl, 3, 2, this.q).monic();
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<ModLong>)this.ar).multiply(Power.positivePower(this.br, l)).multiply(this.cr);
        SortedMap sortedMap = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeModLongTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sortedMap));
    }

    public void testSquarefreeCharRoot() {
        long l = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 3, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll, 3, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, 3, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(Power.positivePower(this.b, l)).multiply(this.c);
        this.c = this.a.multiply((ModLong)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeModLongTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.baseSparsePseudoRemainder(this.d, this.c);
        SquarefreeModLongTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactorsCharRoot() {
        long l = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModLong>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 3, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll, 3, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, 3, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((ModLong)((Object)this.a)).multiply(Power.positivePower(this.b, l)).multiply(this.c);
        SortedMap sortedMap = this.sqf.squarefreeFactors((ModLong)((Object)this.d));
        SquarefreeModLongTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sortedMap));
    }
}

