/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.ps.TaylorFunction;
import edu.jas.structure.RingElem;
import java.util.List;

public class PolynomialTaylorFunction<C extends RingElem<C>>
implements TaylorFunction<C> {
    final GenPolynomial<C> pol;
    final long facul;

    public PolynomialTaylorFunction(GenPolynomial<C> genPolynomial) {
        this(genPolynomial, 1L);
    }

    public PolynomialTaylorFunction(GenPolynomial<C> genPolynomial, long l) {
        this.pol = genPolynomial;
        this.facul = l;
    }

    public String toString() {
        return this.pol.toString();
    }

    @Override
    public long getFacul() {
        return this.facul;
    }

    @Override
    public boolean isZERO() {
        return this.pol.isZERO();
    }

    @Override
    public TaylorFunction<C> deriviative() {
        return new PolynomialTaylorFunction<C>(PolyUtil.baseDeriviative(this.pol));
    }

    @Override
    public TaylorFunction<C> deriviative(ExpVector expVector) {
        GenPolynomial<C> genPolynomial = this.pol;
        long l = 1L;
        if (expVector.signum() == 0 || this.pol.isZERO()) {
            return new PolynomialTaylorFunction<C>(genPolynomial, l);
        }
        for (int i = 0; i < expVector.length(); ++i) {
            long l2 = expVector.getVal(i);
            if (l2 == 0L) continue;
            int n = expVector.length() - 1 - i;
            for (long j = 0L; j < l2; ++j) {
                genPolynomial = PolyUtil.baseDeriviative(genPolynomial, n);
                l *= j + 1L;
                if (!genPolynomial.isZERO()) continue;
                return new PolynomialTaylorFunction<C>(genPolynomial, l);
            }
        }
        return new PolynomialTaylorFunction<C>(genPolynomial, l);
    }

    @Override
    public C evaluate(C c) {
        return PolyUtil.evaluateMain(this.pol.ring.coFac, this.pol, c);
    }

    @Override
    public C evaluate(List<C> list) {
        return PolyUtil.evaluateAll(this.pol.ring.coFac, this.pol, list);
    }
}

