/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorsMap;
import java.util.Map;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorComplexTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorComplexTest.suite());
    }

    public FactorComplexTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorComplexTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void xtestDummy() {
    }

    public void testComplexFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(bigRational);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(complexRing, 1, termOrder);
        FactorComplex<BigRational> factorComplex = new FactorComplex<BigRational>(complexRing);
        for (int i = 1; i < 3; ++i) {
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(2, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial3 = genPolynomialRing.random(2, this.ll + i, this.el + i, this.q);
            if (genPolynomial3.degree() == 0L) {
                genPolynomial3 = genPolynomial3.multiply((RingElem<BigRational>)genPolynomialRing.univariate(0));
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial3 = genPolynomial3.multiply((RingElem<BigRational>)genPolynomial3)).degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorComplex.baseFactors(genPolynomial = genPolynomial2.multiply((BigRational)((Object)genPolynomial3)))).size() >= n) {
                FactorComplexTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                System.out.println("sm.size() < facs = " + n);
            }
            boolean bl = factorComplex.isFactorization(genPolynomial, sortedMap);
            FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testComplexAbsoluteFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(bigRational);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(complexRing, 1, termOrder);
        FactorComplex<BigRational> factorComplex = new FactorComplex<BigRational>(complexRing);
        for (int i = 1; i < 2; ++i) {
            int n = 0;
            GenPolynomial<BigRational> genPolynomial = genPolynomialRing.random(2, this.ll, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial2 = genPolynomialRing.random(2, this.ll, this.el, this.q);
            if (genPolynomial2.degree() == 0L) {
                genPolynomial2 = genPolynomial2.multiply((RingElem<BigRational>)genPolynomialRing.univariate(0));
            }
            if (genPolynomial.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial2 = genPolynomial2.multiply((RingElem<BigRational>)genPolynomial2)).degree() > 0L) {
                ++n;
            }
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial3 = genPolynomial.multiply((BigRational)((Object)genPolynomial2));
            FactorsMap<GenPolynomial<RingElem<BigRational>>> factorsMap = factorComplex.baseFactorsAbsolute(genPolynomial3);
            boolean bl = factorComplex.isAbsoluteFactorization(factorsMap);
            FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            FactorComplexTest.assertTrue((String)"facs <= #sm", (n <= factorsMap.length() ? 1 : 0) != 0);
        }
    }

    public void testBivariateComplexFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(bigRational);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(complexRing, 2, termOrder);
        FactorComplex<BigRational> factorComplex = new FactorComplex<BigRational>(complexRing);
        for (int i = 1; i < 2; ++i) {
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial;
            SortedMap sortedMap;
            int n = 0;
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing.random(2, this.ll + i, this.el, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial3 = genPolynomialRing.random(2, this.ll + i, this.el, this.q);
            if (genPolynomial3.degree() == 0L) {
                genPolynomial3 = genPolynomial3.multiply((RingElem<BigRational>)genPolynomialRing.univariate(0));
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if ((sortedMap = factorComplex.factors(genPolynomial = genPolynomial2.multiply((BigRational)((Object)genPolynomial3)))).size() >= n) {
                FactorComplexTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                System.out.println("sm.size() < facs = " + n);
            }
            boolean bl = factorComplex.isFactorization(genPolynomial, sortedMap);
            FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testComplexFactor() {
        ComplexRing<BigRational> complexRing = new ComplexRing<BigRational>(BigRational.ZERO);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(complexRing, new String[]{"x1", "x0"}, TermOrderByName.INVLEX);
        Element element = genPolynomialRing.parse("x1^12 - x0^12");
        FactorComplex<BigRational> factorComplex = new FactorComplex<BigRational>(complexRing);
        SortedMap sortedMap = factorComplex.factors((GenPolynomial<BigRational>)element);
        for (Map.Entry entry : sortedMap.entrySet()) {
            if (entry.getKey().isONE() && entry.getValue().equals(1L)) continue;
            FactorComplexTest.assertTrue((String)"degree <= 2 ", (entry.getKey().degree() <= 2L ? 1 : 0) != 0);
        }
        boolean bl = factorComplex.isFactorization((GenPolynomial<BigRational>)element, sortedMap);
        FactorComplexTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }
}

