/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.StarRingElem;
import java.util.ArrayList;
import java.util.List;

public class IdealWithComplexAlgebraicRoots<D extends GcdRingElem<D> & Rational>
extends IdealWithUniv<D> {
    public final List<List<Complex<RealAlgebraicNumber<D>>>> can;
    protected List<List<Complex<BigDecimal>>> droots = null;

    protected IdealWithComplexAlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public IdealWithComplexAlgebraicRoots(Ideal<D> ideal, List<GenPolynomial<D>> list, List<List<Complex<RealAlgebraicNumber<D>>>> list2) {
        super(ideal, list);
        this.can = list2;
    }

    public IdealWithComplexAlgebraicRoots(IdealWithUniv<D> idealWithUniv, List<List<Complex<RealAlgebraicNumber<D>>>> list) {
        super(idealWithUniv.ideal, idealWithUniv.upolys);
        this.can = list;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "\ncomplex roots:\n");
        stringBuffer.append("[");
        boolean bl = true;
        for (List<Complex<RealAlgebraicNumber<D>>> list : this.can) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append("[");
            boolean bl2 = true;
            for (Complex<RealAlgebraicNumber<D>> complex : list) {
                if (!bl2) {
                    stringBuffer.append(", ");
                } else {
                    bl2 = false;
                }
                stringBuffer.append(complex.ring.toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        if (this.droots != null) {
            stringBuffer.append("\ndecimal complex root approximation:\n");
            for (List<Complex<GcdRingElem<RealAlgebraicNumber<Object>>>> list : this.droots) {
                stringBuffer.append(list.toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        return super.toScript() + ",  " + this.can.toString();
    }

    public synchronized List<List<Complex<BigDecimal>>> decimalApproximation() {
        if (this.droots != null) {
            return this.droots;
        }
        ArrayList<List<Complex<BigDecimal>>> arrayList = new ArrayList<List<Complex<BigDecimal>>>();
        ComplexRing<BigDecimal> complexRing = new ComplexRing<BigDecimal>(new BigDecimal());
        for (List<Complex<RealAlgebraicNumber<D>>> list : this.can) {
            ArrayList<Complex<BigDecimal>> arrayList2 = new ArrayList<Complex<BigDecimal>>();
            for (Complex<RealAlgebraicNumber<D>> complex : list) {
                BigDecimal bigDecimal = new BigDecimal(complex.getRe().magnitude());
                BigDecimal bigDecimal2 = new BigDecimal(complex.getIm().magnitude());
                Complex<BigDecimal> complex2 = new Complex<BigDecimal>(complexRing, bigDecimal, bigDecimal2);
                arrayList2.add(complex2);
            }
            arrayList.add(arrayList2);
        }
        this.droots = arrayList;
        return arrayList;
    }

    public void doDecimalApproximation() {
        List<List<Complex<BigDecimal>>> list = this.decimalApproximation();
        if (list.isEmpty()) {
            System.out.println("unused is empty");
        }
    }

    public synchronized boolean isDecimalApproximation() {
        RingElem<GenPolynomial<BigDecimal>> ringElem;
        List list;
        this.doDecimalApproximation();
        if (this.droots == null || this.droots.size() == 0) {
            return true;
        }
        if (this.upolys == null || this.upolys.size() == 0) {
            return true;
        }
        Complex<BigDecimal> complex = this.droots.get(0).get(0);
        ComplexRing complexRing = complex.ring;
        StarRingElem starRingElem = new Complex<BigDecimal>(complexRing, (BigDecimal)new BigDecimal("0.15").power(BigDecimal.DEFAULT_PRECISION / 2));
        starRingElem = ((Complex)starRingElem).norm();
        StarRingElem starRingElem2 = new Complex<BigDecimal>(complexRing, (BigDecimal)new BigDecimal("0.1").power(BigDecimal.DEFAULT_PRECISION / 3));
        starRingElem2 = ((Complex)starRingElem2).norm();
        ComplexRing complexRing2 = new ComplexRing(this.ideal.list.ring.coFac);
        ArrayList<GenPolynomial<Complex<BigDecimal>>> arrayList = new ArrayList<GenPolynomial<Complex<BigDecimal>>>(this.upolys.size());
        for (GenPolynomial iterable2 : this.upolys) {
            GenPolynomialRing genPolynomialRing = iterable2.ring;
            list = new GenPolynomialRing(complexRing2, genPolynomialRing);
            GenPolynomialRing<Complex<BigDecimal>> genPolynomialRing2 = new GenPolynomialRing<Complex<BigDecimal>>(complexRing, (GenPolynomialRing)((Object)list));
            GenPolynomial genPolynomial = PolyUtil.complexFromAny(list, iterable2);
            ringElem = PolyUtil.complexDecimalFromRational(genPolynomialRing2, genPolynomial);
            arrayList.add((GenPolynomial<Complex<BigDecimal>>)ringElem);
        }
        for (List list2 : this.droots) {
            int n = 0;
            for (GenPolynomial genPolynomial : arrayList) {
                Complex complex2 = (Complex)list2.get(n++);
                ringElem = PolyUtil.evaluateMain(complexRing, genPolynomial, complex2);
                if (((BigDecimal)((Complex)(ringElem = ((Complex)ringElem).norm())).getRe()).compareTo((BigDecimal)((Complex)starRingElem).getRe()) < 0 || ((BigDecimal)((Complex)ringElem).getRe()).compareTo((BigDecimal)((Complex)starRingElem2).getRe()) < 0) continue;
                System.out.println("no root: z = " + ringElem + ", cc = " + starRingElem2);
                return false;
            }
        }
        GenPolynomialRing genPolynomialRing = this.ideal.list.ring;
        complexRing2 = new ComplexRing(genPolynomialRing.coFac);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(complexRing2, genPolynomialRing);
        GenPolynomialRing<Complex<BigDecimal>> genPolynomialRing4 = new GenPolynomialRing<Complex<BigDecimal>>(complexRing, genPolynomialRing3);
        list = this.ideal.list.list;
        starRingElem = new Complex<BigDecimal>(complexRing, (BigDecimal)new BigDecimal("0.15").power(BigDecimal.DEFAULT_PRECISION / 2 - 1));
        for (GenPolynomial genPolynomial : list) {
            ringElem = PolyUtil.complexFromAny(genPolynomialRing3, genPolynomial);
            GenPolynomial<Complex<BigDecimal>> genPolynomial2 = PolyUtil.complexDecimalFromRational(genPolynomialRing4, ringElem);
            for (List<Complex<BigDecimal>> list3 : this.droots) {
                StarRingElem starRingElem3 = PolyUtil.evaluateAll(complexRing, genPolynomial2, list3);
                if (((BigDecimal)((Complex)(starRingElem3 = ((Complex)starRingElem3).norm())).getRe()).compareTo((BigDecimal)((Complex)starRingElem).getRe()) < 0 || ((BigDecimal)((Complex)starRingElem3).getRe()).compareTo((BigDecimal)((Complex)starRingElem2).getRe()) < 0) continue;
                System.out.println("no root: z = " + starRingElem3 + ", cc = " + starRingElem2);
                System.out.println("ipd = " + genPolynomial2 + ", rr = " + list3);
                return false;
            }
        }
        return true;
    }
}

