/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import javax.swing.SwingUtilities;
import parser.ast.ModulesFile;
import prism.PrismException;
import userinterface.GUIComputationThread;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ParseModelThread
extends GUIComputationThread {
    private GUIMultiModelHandler handler;
    private String parseThis;
    private boolean isPepa;
    private boolean background;
    private ModulesFile mod;
    private String errMsg;
    private PrismException parseError;
    static int counter = 0;
    int id;
    long before;

    public ParseModelThread(GUIMultiModelHandler gUIMultiModelHandler, String string, boolean bl, boolean bl2) {
        super(gUIMultiModelHandler.getGUIPlugin());
        this.handler = gUIMultiModelHandler;
        this.parseThis = string;
        this.isPepa = bl;
        this.background = bl2;
        this.id = counter++;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ParseModelThread.this.background) {
                    ParseModelThread.this.plug.startProgress();
                }
                ParseModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ParseModelThread.this.plug));
                if (!ParseModelThread.this.background) {
                    ParseModelThread.this.plug.setTaskBarText("Parsing model...");
                }
            }
        });
        try {
            if (!this.isPepa) {
                if (!this.background) {
                    this.plug.log("\nParsing model...\n");
                }
                this.mod = this.prism.parseModelString(this.parseThis);
            } else {
                if (!this.background) {
                    this.plug.log("\nParsing PEPA model...\n");
                }
                this.mod = this.prism.importPepaString(this.parseThis);
            }
            this.prism.loadPRISMModel(this.mod);
        }
        catch (PrismException prismException) {
            this.parseError = prismException;
            this.errMsg = prismException.getMessage();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ParseModelThread.this.background) {
                        ParseModelThread.this.plug.stopProgress();
                    }
                    ParseModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ParseModelThread.this.plug));
                    if (!ParseModelThread.this.background) {
                        ParseModelThread.this.plug.setTaskBarText("Parsing model... error.");
                    }
                    if (!ParseModelThread.this.background) {
                        ParseModelThread.this.error(ParseModelThread.this.errMsg);
                    }
                    ParseModelThread.this.handler.modelParseFailed(ParseModelThread.this.parseError, ParseModelThread.this.background);
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ParseModelThread.this.background) {
                    ParseModelThread.this.plug.stopProgress();
                }
                if (!ParseModelThread.this.background) {
                    ParseModelThread.this.plug.setTaskBarText("Parsing model... done.");
                }
                ParseModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ParseModelThread.this.plug));
                ParseModelThread.this.handler.modelParsedSuccessful(ParseModelThread.this.mod);
            }
        });
    }
}

