/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import prism.ModelGenerator;
import prism.PrismException;
import simulator.Path;
import simulator.sampler.SamplerBoolean;

public class SamplerBoundedUntilCont
extends SamplerBoolean {
    private Expression left;
    private Expression right;
    private double lb;
    private double ub;

    public SamplerBoundedUntilCont(ExpressionTemporal expressionTemporal) throws PrismException {
        if (expressionTemporal.getOperator() != 2) {
            throw new PrismException("Error creating Sampler");
        }
        this.left = expressionTemporal.getOperand1();
        this.right = expressionTemporal.getOperand2();
        double d = this.lb = expressionTemporal.getLowerBound() == null ? 0.0 : expressionTemporal.getLowerBound().evaluateDouble();
        if (this.lb < 0.0) {
            throw new PrismException("Invalid lower bound " + this.lb + " in time-bounded until formula");
        }
        if (expressionTemporal.getUpperBound() == null) {
            this.ub = Double.POSITIVE_INFINITY;
        } else {
            this.ub = expressionTemporal.getUpperBound().evaluateDouble();
            if (this.ub < 0.0 || this.ub == 0.0 && expressionTemporal.upperBoundIsStrict()) {
                String string = (expressionTemporal.upperBoundIsStrict() ? "<" : "<=") + this.ub;
                throw new PrismException("Invalid upper bound " + string + " in time-bounded until formula");
            }
            if (this.ub < this.lb) {
                throw new PrismException("Upper bound must exceed lower bound in time-bounded until formula");
            }
        }
        this.reset();
        this.resetStats();
    }

    @Override
    public boolean update(Path path, ModelGenerator modelGenerator) throws PrismException {
        if (this.valueKnown) {
            return true;
        }
        if (path.size() == 0L) {
            if (this.lb == 0.0 && path.evaluateBooleanInCurrentState(this.right)) {
                this.valueKnown = true;
                this.value = true;
            } else if (!path.evaluateBooleanInCurrentState(this.left)) {
                this.valueKnown = true;
                this.value = false;
            }
        } else {
            double d = path.getTotalTime();
            if (d > this.ub) {
                if (path.evaluateBooleanInPreviousState(this.right)) {
                    this.valueKnown = true;
                    this.value = true;
                } else {
                    this.valueKnown = true;
                    this.value = false;
                }
            } else if (d <= this.lb) {
                if (!path.evaluateBooleanInCurrentState(this.left)) {
                    this.valueKnown = true;
                    this.value = false;
                }
            } else if (path.evaluateBooleanInCurrentState(this.right)) {
                this.valueKnown = true;
                this.value = true;
            } else if (!path.evaluateBooleanInCurrentState(this.left)) {
                this.valueKnown = true;
                this.value = false;
            } else if (d - path.getTimeInPreviousState() <= this.lb) {
                if (path.evaluateBooleanInPreviousState(this.right)) {
                    this.valueKnown = true;
                    this.value = true;
                }
            } else if (modelGenerator != null && modelGenerator.isDeadlock()) {
                this.valueKnown = true;
                this.value = false;
            }
        }
        return this.valueKnown;
    }

    @Override
    public boolean needsBoundedNumSteps() {
        return this.ub < Double.POSITIVE_INFINITY;
    }
}

