/*
 * Decompiled with CFR 0.152.
 */
package simulator.sampler;

import parser.ast.Expression;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import prism.ModelGenerator;
import prism.ModelInfo;
import prism.PrismException;
import prism.RewardGenerator;
import simulator.Path;
import simulator.method.SimulationMethod;
import simulator.sampler.SamplerBoolean;
import simulator.sampler.SamplerBoundedUntilCont;
import simulator.sampler.SamplerBoundedUntilDisc;
import simulator.sampler.SamplerDouble;
import simulator.sampler.SamplerNext;
import simulator.sampler.SamplerRewardCumulCont;
import simulator.sampler.SamplerRewardCumulDisc;
import simulator.sampler.SamplerRewardInstCont;
import simulator.sampler.SamplerRewardInstDisc;
import simulator.sampler.SamplerRewardReach;
import simulator.sampler.SamplerUntil;

public abstract class Sampler {
    protected boolean valueKnown;
    protected SimulationMethod simulationMethod;

    public boolean isCurrentValueKnown() {
        return this.valueKnown;
    }

    public boolean needsBoundedNumSteps() {
        return false;
    }

    public abstract void reset();

    public abstract void resetStats();

    public abstract boolean update(Path var1, ModelGenerator var2) throws PrismException;

    public abstract void updateStats();

    public abstract Object getCurrentValue();

    public abstract double getMeanValue();

    public abstract double getVariance();

    public abstract double getLikelihoodRatio(double var1, double var3) throws PrismException;

    public void setSimulationMethod(SimulationMethod simulationMethod) {
        this.simulationMethod = simulationMethod;
    }

    public SimulationMethod getSimulationMethod() {
        return this.simulationMethod;
    }

    public String getSimulationMethodResultExplanation() throws PrismException {
        return this.simulationMethod.getResultExplanation(this);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Sampler createSampler(Expression expression, ModelInfo modelInfo, RewardGenerator rewardGenerator) throws PrismException {
        void var3_6;
        Object var3_3 = null;
        if (expression instanceof ExpressionProb) {
            ExpressionProb expressionProb = (ExpressionProb)expression;
            if (!expressionProb.getExpression().isSimplePathFormula()) throw new PrismException("LTL-style path formulas are not supported by the simulator");
            SamplerBoolean samplerBoolean = Sampler.createSamplerForProbPathPropertySimple(expressionProb.getExpression(), modelInfo);
            return var3_6;
        } else {
            if (!(expression instanceof ExpressionReward)) throw new PrismException("Can't create sampler for property \"" + String.valueOf(expression) + "\"");
            SamplerDouble samplerDouble = Sampler.createSamplerForRewardProperty((ExpressionReward)expression, modelInfo, rewardGenerator);
        }
        return var3_6;
    }

    private static SamplerBoolean createSamplerForProbPathPropertySimple(Expression expression, ModelInfo modelInfo) throws PrismException {
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            if (expressionUnaryOp.getOperator() == 3) {
                return Sampler.createSamplerForProbPathPropertySimple(expressionUnaryOp.getOperand(), modelInfo);
            }
            if (expressionUnaryOp.getOperator() == 1) {
                SamplerBoolean samplerBoolean = Sampler.createSamplerForProbPathPropertySimple(expressionUnaryOp.getOperand(), modelInfo);
                samplerBoolean.negate();
                return samplerBoolean;
            }
        } else if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.getOperator() == 1) {
                return new SamplerNext(expressionTemporal);
            }
            if (expressionTemporal.getOperator() == 2) {
                if (expressionTemporal.hasBounds()) {
                    if (modelInfo.getModelType().continuousTime()) {
                        return new SamplerBoundedUntilCont(expressionTemporal);
                    }
                    return new SamplerBoundedUntilDisc(expressionTemporal);
                }
                return new SamplerUntil(expressionTemporal);
            }
            return Sampler.createSamplerForProbPathPropertySimple(expressionTemporal.convertToUntilForm(), modelInfo);
        }
        throw new PrismException("Can't create sampler for property \"" + String.valueOf(expression) + "\"");
    }

    private static SamplerDouble createSamplerForRewardProperty(ExpressionReward expressionReward, ModelInfo modelInfo, RewardGenerator rewardGenerator) throws PrismException {
        int n = expressionReward.getRewardStructIndexByIndexObject(rewardGenerator, null);
        if (!(expressionReward.getExpression() instanceof ExpressionTemporal)) {
            throw new PrismException("Can't create sampler for property \"" + String.valueOf(expressionReward) + "\"");
        }
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)expressionReward.getExpression();
        switch (expressionTemporal.getOperator()) {
            case 11: {
                if (modelInfo.getModelType().continuousTime()) {
                    return new SamplerRewardCumulCont(expressionTemporal, n);
                }
                return new SamplerRewardCumulDisc(expressionTemporal, n);
            }
            case 12: {
                if (modelInfo.getModelType().continuousTime()) {
                    return new SamplerRewardInstCont(expressionTemporal, n);
                }
                return new SamplerRewardInstDisc(expressionTemporal, n);
            }
            case 3: {
                if (!expressionTemporal.isSimplePathFormula()) {
                    throw new PrismException("Can't create sampler for property \"" + String.valueOf(expressionTemporal) + "\"");
                }
                return new SamplerRewardReach(expressionTemporal, n);
            }
        }
        throw new PrismException("Can't create sampler for property \"" + String.valueOf(expressionReward) + "\"");
    }
}

