/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import cern.jet.stat.Probability;
import prism.Accuracy;
import prism.PrismException;
import simulator.method.CIMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public final class CIwidth
extends CIMethod {
    private double varEstimator;

    public CIwidth(double d, int n) {
        this.confidence = d;
        this.numSamples = n;
        this.varEstimator = 0.0;
    }

    @Override
    public void computeMissingParameterAfterSim() {
        if (this.numSamples > 1) {
            double d = this.numSamples - 1 > 1 ? Probability.studentTInverse((double)this.confidence, (int)(this.numSamples - 1)) : Math.tan((0.5 - this.confidence / 2.0) * Math.PI);
            this.width = d * Math.sqrt(this.varEstimator / (double)this.numSamples);
            this.missingParameterComputed = true;
        }
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.width;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "width=unknown, confidence=" + this.confidence + ", number of samples=" + this.numSamples;
        }
        return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        if (n >= this.numSamples) {
            this.varEstimator = sampler.getVariance();
            return true;
        }
        return false;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        return 10 * n / this.numSamples * 10;
    }

    @Override
    public Object getResult(Sampler sampler) throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterAfterSim();
        }
        return super.getResult(sampler);
    }

    @Override
    public Accuracy getResultAccuracy(Sampler sampler) throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterAfterSim();
        }
        return super.getResultAccuracy(sampler);
    }

    @Override
    public String getResultExplanation(Sampler sampler) throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterAfterSim();
        }
        return super.getResultExplanation(sampler);
    }

    @Override
    public SimulationMethod clone() {
        CIwidth cIwidth = new CIwidth(this.confidence, this.numSamples);
        cIwidth.width = this.width;
        cIwidth.missingParameterComputed = this.missingParameterComputed;
        cIwidth.prOp = this.prOp;
        cIwidth.theta = this.theta;
        cIwidth.varEstimator = this.varEstimator;
        return cIwidth;
    }
}

