/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import prism.PrismException;
import simulator.method.APMCMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public class APMCapproximation
extends APMCMethod {
    public APMCapproximation(double d, int n) {
        this.confidence = d;
        this.numSamples = n;
    }

    @Override
    public void computeMissingParameterBeforeSim() throws PrismException {
        this.approximation = Math.sqrt(0.5 * Math.log(2.0 / this.confidence) / (double)this.numSamples);
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterBeforeSim();
        }
        return this.approximation;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "approximation=unknown, confidence=" + this.confidence + ", number of samples=" + this.numSamples;
        }
        return "approximation=" + this.approximation + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public Object getResult(Sampler sampler) throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterBeforeSim();
        }
        return super.getResult(sampler);
    }

    @Override
    public SimulationMethod clone() {
        APMCapproximation aPMCapproximation = new APMCapproximation(this.confidence, this.numSamples);
        aPMCapproximation.approximation = this.approximation;
        aPMCapproximation.missingParameterComputed = this.missingParameterComputed;
        aPMCapproximation.prOp = this.prOp;
        aPMCapproximation.theta = this.theta;
        return aPMCapproximation;
    }
}

