/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;

public class ChoiceEditor
implements SettingEditor,
ActionListener,
FocusListener {
    private Font font = new Font("monospaced", 0, 12);
    private String[] choices;
    private JComboBox combo;
    private JTable lastTable;
    private boolean modified = false;

    public ChoiceEditor(String[] stringArray) {
        this.combo = new JComboBox<String>(stringArray);
        this.combo.addActionListener(this);
        this.combo.addFocusListener(this);
        this.choices = stringArray;
    }

    @Override
    public Object getEditorValue() throws SettingException {
        if (this.modified) {
            this.modified = false;
            if (this.combo.getSelectedItem() != null) {
                return this.combo.getSelectedItem().toString();
            }
            return "$%^&*NOTCHANGED*&^%$";
        }
        return "$%^&*NOTCHANGED*&^%$";
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        ArrayList arrayList;
        if (bl) {
            this.combo.setForeground(jTable.getSelectionForeground());
            this.combo.setBackground(jTable.getSelectionBackground());
        } else {
            this.combo.setForeground(jTable.getForeground());
            this.combo.setBackground(jTable.getBackground());
        }
        this.combo.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.combo.setFont(this.font);
        this.combo.setFocusable(false);
        if (object instanceof String) {
            int n3 = -1;
            for (int i = 0; i < this.choices.length; ++i) {
                if (!this.choices[i].equals(object.toString())) continue;
                n3 = i;
                break;
            }
            this.combo.setSelectedIndex(n3);
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            int n4;
            String string = null;
            boolean bl2 = true;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                if (!(arrayList.get(n4) instanceof String)) continue;
                String string2 = (String)arrayList.get(n4);
                if (string != null) {
                    if (!string2.equals(string)) {
                        bl2 = false;
                        break;
                    }
                    string = string2;
                    continue;
                }
                string = string2;
            }
            if (bl2) {
                n4 = -1;
                for (int i = 0; i < this.choices.length; ++i) {
                    if (!this.choices[i].equals(string)) continue;
                    n4 = i;
                    break;
                }
                this.combo.setSelectedIndex(n4);
            } else {
                this.combo.setSelectedIndex(-1);
            }
        }
        this.lastTable = jTable;
        return this.combo;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.modified = true;
        if (this.lastTable != null) {
            this.lastTable.editingStopped(new ChangeEvent(this));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.lastTable.getCellEditor() != null) {
            this.lastTable.removeEditor();
        }
    }
}

