/*
 * Decompiled with CFR 0.152.
 */
package pta;

import pta.DB;
import pta.PTA;

public class Constraint {
    protected int x;
    protected int y;
    protected int db;

    private Constraint(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.db = n3;
    }

    public Constraint(Constraint constraint) {
        this(constraint.x, constraint.y, constraint.db);
    }

    public int hashCode() {
        return (this.db * 7 + this.x) * 7 + this.y;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Constraint)) {
            return false;
        }
        Constraint constraint = (Constraint)object;
        return this.db == constraint.db && this.x == constraint.x && this.y == constraint.y;
    }

    public Constraint deepCopy() {
        return new Constraint(this.x, this.y, this.db);
    }

    public Constraint renameClocks(PTA pTA, PTA pTA2) {
        this.x = PTA.renameClock(pTA, pTA2, this.x);
        this.y = PTA.renameClock(pTA, pTA2, this.y);
        return this;
    }

    public String toString(PTA pTA) {
        return DB.constraintToString(this.x, this.y, this.db, pTA);
    }

    public static String toStringList(PTA pTA, Iterable<Constraint> iterable) {
        Object object = "";
        if (iterable == null || !iterable.iterator().hasNext()) {
            object = (String)object + "true";
        } else {
            boolean bl = true;
            for (Constraint constraint : iterable) {
                if (bl) {
                    bl = false;
                } else {
                    object = (String)object + ",";
                }
                object = (String)object + constraint.toString(pTA);
            }
        }
        return object;
    }

    public static Constraint buildLeq(int n, int n2) {
        return new Constraint(n, 0, DB.createLeq(n2));
    }

    public static Constraint buildLt(int n, int n2) {
        return new Constraint(n, 0, DB.createLt(n2));
    }

    public static Constraint buildGeq(int n, int n2) {
        return new Constraint(0, n, DB.createLeq(-n2));
    }

    public static Constraint buildGt(int n, int n2) {
        return new Constraint(0, n, DB.createLt(-n2));
    }

    public static Constraint buildXLeqY(int n, int n2) {
        return new Constraint(n, n2, DB.createLeq(0));
    }

    public static Constraint buildXLtY(int n, int n2) {
        return new Constraint(n, n2, DB.createLt(0));
    }

    public static Constraint buildXGeqY(int n, int n2) {
        return new Constraint(n2, n, DB.createLeq(0));
    }

    public static Constraint buildXGtY(int n, int n2) {
        return new Constraint(n2, n, DB.createLt(0));
    }

    public static Constraint buildXYLeq(int n, int n2, int n3) {
        return new Constraint(n, n2, DB.createLeq(n3));
    }

    public static Constraint buildXYLt(int n, int n2, int n3) {
        return new Constraint(n, n2, DB.createLt(n3));
    }

    public static Constraint buildXYGeq(int n, int n2, int n3) {
        return new Constraint(n2, n, DB.createLeq(-n3));
    }

    public static Constraint buildXYGt(int n, int n2, int n3) {
        return new Constraint(n2, n, DB.createLt(-n3));
    }
}

