/*
 * Decompiled with CFR 0.152.
 */
package prism;

import com.martiansoftware.nailgun.NGContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import prism.PrismCL;
import prism.PrismNative;

public class PrismNG {
    private static NGContext currentNailGunContext = null;
    private static final String envNameNGMainClass = "NG_MAINCLASS";

    public static synchronized void nailMain(NGContext nGContext) throws InterruptedException {
        currentNailGunContext = nGContext;
        if (PrismNative.setWorkingDirectory(nGContext.getWorkingDirectory()) != 0) {
            System.err.println("Nailgun: Can not change working directory to " + nGContext.getWorkingDirectory());
            System.exit(1);
        }
        String string = null;
        try {
            string = System.getenv(envNameNGMainClass);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            PrismCL.main(nGContext.getArgs());
        } else {
            Class<?> clazz = null;
            try {
                clazz = nGContext.getClass().getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("PrismNG: Can not find class '" + string + "' (from environment variable NG_MAINCLASS)");
                System.exit(1);
            }
            String[] stringArray = nGContext.getArgs();
            Method method = null;
            try {
                method = clazz.getMethod("main", stringArray.getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("PrismNG: Class '" + string + "' (from environment variable NG_MAINCLASS) does not have a suitable main method");
                System.exit(1);
            }
            catch (SecurityException securityException) {
                System.err.println("PrismNG: Security exception trying to load main method of class '" + string + "' (from environment variable NG_MAINCLASS): " + securityException.getMessage());
                System.exit(1);
            }
            try {
                method.invoke(null, new Object[]{stringArray});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                System.err.println("PrismNG: Exception trying to invoke main method of class '" + string + "' (from environment variable NG_MAINCLASS): " + exception.getMessage());
                System.exit(1);
            }
        }
    }

    public static void setupChildProcessEnvironment(ProcessBuilder processBuilder) {
        if (currentNailGunContext == null) {
            return;
        }
        Map<String, String> map = processBuilder.environment();
        for (Map.Entry<Object, Object> entry : currentNailGunContext.getEnv().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

