/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ActionList {
    protected Supplier<List<Object>> newActionSource;
    protected List<Object> actionList;
    protected Map<Object, Integer> actionLookup;
    protected boolean needsRecomputing;
    protected boolean neverRecompute;

    public ActionList(Supplier<List<Object>> supplier) {
        this.newActionSource = supplier;
        this.actionList = new ArrayList<Object>();
        this.actionLookup = new HashMap<Object, Integer>();
        this.needsRecomputing = true;
        this.neverRecompute = false;
    }

    public ActionList(List<Object> list, Supplier<List<Object>> supplier) {
        this(supplier);
        this.setActions(list);
    }

    public void copyFrom(ActionList actionList) {
        this.actionList = new ArrayList<Object>(actionList.actionList);
        this.actionLookup = new HashMap<Object, Integer>(actionList.actionLookup);
        this.needsRecomputing = actionList.needsRecomputing;
        this.neverRecompute = actionList.neverRecompute;
    }

    public void setActions(List<Object> list) {
        this.actionList.clear();
        this.actionLookup.clear();
        this.addActions(list);
        this.needsRecomputing = false;
        this.neverRecompute = true;
    }

    public void clear() {
        this.actionList.clear();
        this.actionLookup.clear();
        this.needsRecomputing = true;
        this.neverRecompute = false;
    }

    public int addAction(Object object) {
        Integer n = this.actionLookup.get(object);
        if (n == null) {
            n = this.actionList.size();
            this.actionLookup.put(object, n);
            this.actionList.add(object);
        }
        return n;
    }

    public void addActions(List<Object> list) {
        list.forEach(this::addAction);
    }

    public void markNeedsRecomputing() {
        this.needsRecomputing = true;
    }

    private void recompute() {
        this.newActionSource.get().forEach(this::addAction);
        this.needsRecomputing = false;
    }

    public List<Object> getActions() {
        if (this.needsRecomputing && !this.neverRecompute) {
            this.recompute();
        }
        return this.actionList;
    }

    public int actionIndex(Object object) {
        Integer n;
        if (this.needsRecomputing && !this.neverRecompute) {
            this.recompute();
        }
        return (n = this.actionLookup.get(object)) == null ? -1 : n;
    }

    public static String actionString(Object object) {
        return object == null ? "" : object.toString();
    }

    public String toString() {
        return this.actionList.toString();
    }
}

