/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.Collections;
import java.util.List;
import param.BigRational;
import param.Function;
import param.FunctionFactory;
import param.ParamMode;
import param.Point;
import param.RegionValues;
import parser.EvaluateContext;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionLiteral;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;

public class ParamResult {
    private ParamMode mode;
    private RegionValues regionValues;
    private FunctionFactory factory;

    public ParamResult(ParamMode paramMode, RegionValues regionValues, FunctionFactory functionFactory) {
        this.mode = paramMode;
        this.regionValues = regionValues;
        this.factory = functionFactory;
    }

    public RegionValues getRegionValues() {
        return this.regionValues;
    }

    public String toString() {
        return this.regionValues.toStringInitState();
    }

    public Object getSimpleResult(Type type) throws PrismException {
        if (this.regionValues.getNumRegions() != 1) {
            throw new PrismException("Unexpected result from " + String.valueOf((Object)this.mode) + " model checker");
        }
        if (type.equals(TypeBool.getInstance())) {
            boolean bl = this.regionValues.getResult(0).getInitStateValueAsBoolean();
            return bl;
        }
        Function function = this.regionValues.getResult(0).getInitStateValueAsFunction();
        BigRational bigRational = function.evaluate(new Point(new BigRational[]{new BigRational(0L)}));
        return bigRational;
    }

    public boolean test(Type type, String string, Values values, List<String> list) throws PrismException {
        Expression expression = null;
        try {
            if (string.equals("Infinity") || string.equals("+Infinity") || string.equals("Inf") || string.equals("+Inf")) {
                expression = new ExpressionLiteral(TypeDouble.getInstance(), BigRational.INF);
            } else if (string.equals("-Infinity") || string.equals("-Inf")) {
                expression = new ExpressionLiteral(TypeDouble.getInstance(), BigRational.MINF);
            } else if (string.equals("NaN")) {
                expression = new ExpressionLiteral(TypeDouble.getInstance(), BigRational.NAN);
            } else {
                expression = Prism.parseSingleExpressionString(string);
                expression = (Expression)expression.findAllConstants(values.getNames(), values.getTypes());
                expression = (Expression)expression.findAllConstants(list, Collections.nCopies(list.size(), TypeDouble.getInstance()));
                expression.typeCheck();
                expression = (Expression)expression.evaluatePartially(values);
            }
        }
        catch (PrismLangException prismLangException) {
            throw new PrismException("Invalid RESULT specification \"" + string + "\" for property: " + prismLangException.getMessage());
        }
        return this.test(type, expression, string);
    }

    private boolean test(Type type, Expression expression, String string) throws PrismException {
        if (this.regionValues.getNumRegions() != 1) {
            throw new PrismNotSupportedException("Testing " + String.valueOf((Object)this.mode) + " results with multiple regions not supported");
        }
        if (type.equals(TypeBool.getInstance())) {
            boolean bl;
            boolean bl2 = this.regionValues.getResult(0).getInitStateValueAsBoolean();
            if (bl2 != (bl = expression.evaluateBoolean(EvaluateContext.create(EvaluateContext.EvalMode.EXACT)))) {
                throw new PrismException("Wrong result (expected " + string + ", got " + bl2 + ")");
            }
        } else {
            Function function;
            try {
                function = this.factory.expr2function(expression);
            }
            catch (PrismException prismException) {
                throw new PrismException("Invalid (or unsupported) RESULT specification \"" + string + "\" for " + String.valueOf((Object)this.mode) + " property");
            }
            Function function2 = this.regionValues.getResult(0).getInitStateValueAsFunction();
            if (!function2.equals(function)) {
                throw new PrismException("Wrong result (expected " + string + " = " + String.valueOf(function) + ", got " + String.valueOf(function2) + ")");
            }
        }
        return true;
    }
}

