/*
 * Decompiled with CFR 0.152.
 */
package io;

import csv.BasicReader;
import csv.CsvFormatException;
import csv.CsvReader;
import csv.ReplacingReader;
import explicit.DTMCSimple;
import explicit.ModelExplicit;
import explicit.NondetModel;
import explicit.SuccessorsIterator;
import io.ExplicitModelImporter;
import io.IOUtils;
import io.ModelExportTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import param.BigRational;
import parser.State;
import parser.ast.DeclarationBool;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeInt;
import prism.BasicModelInfo;
import prism.BasicRewardInfo;
import prism.Evaluator;
import prism.ModelInfo;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.RewardInfo;

public class PrismExplicitImporter
extends ExplicitModelImporter {
    private File statesFile;
    private File transFile;
    private File observationsFile;
    private File labelsFile;
    private List<File> stateRewardsFiles;
    private List<File> transRewardsFiles;
    private ModelType typeOverride;
    private boolean transFileStoresInitialStates;
    private BasicModelInfo basicModelInfo;
    private String modelTypeString;
    private ModelStats modelStats;
    private DeadlockInfo deadlockInfo;
    private List<Integer> labelMap;
    private BasicRewardInfo basicRewardInfo;
    private List<RewardFile> stateRewardsReaders = new ArrayList<RewardFile>();
    private List<RewardFile> transRewardsReaders = new ArrayList<RewardFile>();
    protected static final Pattern COMMENT_PATTERN = Pattern.compile("#.*");
    protected static final Pattern REWARD_NAME_PATTERN = Pattern.compile("# Reward structure (\"([_a-zA-Z0-9]*)\")$");

    public PrismExplicitImporter(File file, File file2, File file3, List<File> list, List<File> list2, ModelType modelType) throws PrismException {
        this.setStatesFile(file);
        this.setTransFile(file2);
        this.setLabelsFile(file3);
        this.stateRewardsFiles = new ArrayList<File>();
        this.stateRewardsReaders = new ArrayList<RewardFile>();
        if (list != null) {
            for (File file4 : list) {
                this.addStateRewardsFile(file4);
            }
        }
        this.transRewardsFiles = new ArrayList<File>();
        this.transRewardsReaders = new ArrayList<RewardFile>();
        if (list2 != null) {
            for (File file4 : list2) {
                this.addTransitionRewardsFile(file4);
            }
        }
        this.typeOverride = modelType;
    }

    public PrismExplicitImporter(File file, ModelType modelType) throws PrismException {
        this(null, file, null, null, null, modelType);
    }

    public PrismExplicitImporter(File file) throws PrismException {
        this(null, null);
    }

    public void setStatesFile(File file) {
        this.statesFile = file;
    }

    public void setTransFile(File file) {
        this.transFile = file;
    }

    public void setObservationsFile(File file) {
        this.observationsFile = file;
    }

    public void setLabelsFile(File file) {
        this.labelsFile = file;
    }

    public void addStateRewardsFile(File file) throws PrismException {
        this.stateRewardsFiles.add(file);
        this.stateRewardsReaders.add(new RewardFile(file));
    }

    public void addTransitionRewardsFile(File file) throws PrismException {
        this.transRewardsFiles.add(file);
        this.transRewardsReaders.add(new RewardFile(file));
    }

    public File getStatesFile() {
        return this.statesFile;
    }

    public File getTransFile() {
        return this.transFile;
    }

    public File getObservationsFile() {
        return this.observationsFile;
    }

    public File getLabelsFile() {
        return this.labelsFile;
    }

    public List<File> getAllFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.transFile != null) {
            arrayList.add(this.transFile);
        }
        if (this.statesFile != null) {
            arrayList.add(this.statesFile);
        }
        if (this.observationsFile != null) {
            arrayList.add(this.observationsFile);
        }
        if (this.labelsFile != null) {
            arrayList.add(this.labelsFile);
        }
        if (this.stateRewardsFiles != null) {
            arrayList.addAll(this.stateRewardsFiles);
        }
        if (this.transRewardsFiles != null) {
            arrayList.addAll(this.transRewardsFiles);
        }
        return arrayList;
    }

    @Override
    public boolean providesStates() {
        return this.getStatesFile() != null;
    }

    @Override
    public boolean providesObservations() {
        return this.getObservationsFile() != null;
    }

    @Override
    public boolean providesLabels() {
        return this.getLabelsFile() != null;
    }

    private boolean transFileProvidesInitialStates() throws PrismException {
        if (this.modelStats == null) {
            this.buildModelStats();
        }
        return this.transFileStoresInitialStates;
    }

    @Override
    public String sourceString() {
        return this.getAllFiles().stream().map(file -> "\"" + file.toString() + "\"").collect(Collectors.joining(", "));
    }

    @Override
    public ModelInfo getModelInfo() throws PrismException {
        if (this.basicModelInfo == null) {
            this.buildModelInfo();
        }
        return this.basicModelInfo;
    }

    @Override
    public int getNumStates() throws PrismException {
        if (this.modelStats == null) {
            this.buildModelStats();
        }
        return this.modelStats.numStates;
    }

    @Override
    public int getNumChoices() throws PrismException {
        if (this.modelStats == null) {
            this.buildModelStats();
        }
        int n = this.modelStats.numChoices;
        if (this.fixdl) {
            n += this.getNumDeadlockStates();
        }
        return n;
    }

    @Override
    public int getNumTransitions() throws PrismException {
        if (this.modelStats == null) {
            this.buildModelStats();
        }
        int n = this.modelStats.numTransitions;
        if (this.fixdl) {
            n += this.getNumDeadlockStates();
        }
        return n;
    }

    @Override
    public int getNumObservations() throws PrismException {
        if (!this.getModelInfo().getModelType().partiallyObservable()) {
            return 0;
        }
        if (this.modelStats == null) {
            this.buildModelStats();
        }
        return this.modelStats.numObservations;
    }

    @Override
    public BitSet getDeadlockStates() throws PrismException {
        if (this.deadlockInfo == null) {
            this.findDeadlocks();
        }
        return this.deadlockInfo.deadlocks;
    }

    @Override
    public int getNumDeadlockStates() throws PrismException {
        if (this.deadlockInfo == null) {
            this.findDeadlocks();
        }
        return this.deadlockInfo.numDeadlocks;
    }

    @Override
    public String getModelTypeString() {
        return this.modelTypeString;
    }

    @Override
    public RewardInfo getRewardInfo() throws PrismException {
        if (this.basicRewardInfo == null) {
            this.buildRewardInfo();
        }
        return this.basicRewardInfo;
    }

    private void buildModelStats() throws PrismException {
        this.extractModelStatsFromTransFile(this.transFile);
    }

    private void buildModelInfo() throws PrismException {
        ModelType modelType;
        if (this.modelStats == null) {
            this.buildModelStats();
        }
        if (this.typeOverride == null) {
            ModelType modelType2 = this.autodetectModelType(this.transFile);
            if (modelType2 != null) {
                this.modelTypeString = String.valueOf((Object)modelType2) + " (auto-detected)";
            } else {
                modelType2 = ModelType.MDP;
                this.modelTypeString = String.valueOf((Object)modelType2) + " (default)";
            }
            modelType = modelType2;
        } else {
            this.modelTypeString = String.valueOf((Object)this.typeOverride) + " (user-specified)";
            modelType = this.typeOverride;
        }
        this.basicModelInfo = new BasicModelInfo(modelType);
        if (this.statesFile != null) {
            this.extractVarInfoFromStatesFile(this.statesFile);
        } else {
            this.basicModelInfo.getVarList().addVar(this.defaultVariableName(), this.defaultVariableDeclarationType(), -1);
        }
        if (modelType.partiallyObservable() && this.observationsFile != null) {
            this.extractObservableInfoFromObservationsFile(this.observationsFile);
        } else {
            this.basicModelInfo.getObservableNames().add(this.defaultObservableName());
            this.basicModelInfo.getObservableTypeList().add(this.defaultObservableType());
        }
        if (this.labelsFile != null) {
            this.extractLabelNamesFromLabelsFile(this.labelsFile);
        } else {
            this.labelMap = new ArrayList<Integer>();
        }
    }

    private void extractVarInfoFromStatesFile(File file) throws PrismException {
        this.extractVarInfoFromFile(file, ModelExportTask.ModelExportEntity.STATES);
    }

    private void extractObservableInfoFromObservationsFile(File file) throws PrismException {
        this.extractVarInfoFromFile(file, ModelExportTask.ModelExportEntity.OBSERVATIONS);
    }

    private void extractVarInfoFromFile(File file, ModelExportTask.ModelExportEntity modelExportEntity) throws PrismException {
        String string = modelExportEntity == ModelExportTask.ModelExportEntity.STATES ? "state" : "observation";
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string2 = bufferedReader.readLine();
            n = 1;
            if (string2 == null) {
                throw new PrismException("empty " + string + "s file");
            }
            if ((string2 = string2.trim()).charAt(0) != '(' || string2.charAt(string2.length() - 1) != ')') {
                throw new PrismException("badly formatted " + string);
            }
            string2 = string2.substring(1, string2.length() - 1);
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string2.split(",")));
            int n2 = arrayList.size();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            ArrayList<Type> arrayList2 = new ArrayList<Type>();
            string2 = bufferedReader.readLine();
            ++n;
            int n3 = 0;
            while (string2 != null) {
                if ((string2 = string2.trim()).length() > 0) {
                    ++n3;
                    String[] stringArray = (string2 = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41))).split(",");
                    if (stringArray.length != n2) {
                        throw new PrismException("wrong number of variables");
                    }
                    for (int i = 0; i < n2; ++i) {
                        if (n3 == 1) {
                            if (stringArray[i].equals("true") || stringArray[i].equals("false")) {
                                arrayList2.add(TypeBool.getInstance());
                            } else {
                                arrayList2.add(TypeInt.getInstance());
                            }
                        }
                        if (!(arrayList2.get(i) instanceof TypeInt)) continue;
                        int n4 = Integer.parseInt(stringArray[i]);
                        if (n3 == 1) {
                            nArray[i] = nArray2[i] = n4;
                            continue;
                        }
                        if (n4 < nArray[i]) {
                            nArray[i] = n4;
                        }
                        if (n4 <= nArray2[i]) continue;
                        nArray2[i] = n4;
                    }
                }
                string2 = bufferedReader.readLine();
                ++n;
            }
            if (modelExportEntity == ModelExportTask.ModelExportEntity.STATES) {
                for (int i = 0; i < n2; ++i) {
                    if (arrayList2.get(i) instanceof TypeBool) {
                        this.basicModelInfo.getVarList().addVar((String)arrayList.get(i), new DeclarationBool(), -1);
                        continue;
                    }
                    if (nArray[i] == nArray2[i]) {
                        int n5 = i;
                        nArray2[n5] = nArray2[n5] + 1;
                    }
                    this.basicModelInfo.getVarList().addVar((String)arrayList.get(i), new DeclarationInt(Expression.Int(nArray[i]), Expression.Int(nArray2[i])), -1);
                }
            } else if (modelExportEntity == ModelExportTask.ModelExportEntity.OBSERVATIONS) {
                for (int i = 0; i < n2; ++i) {
                    this.basicModelInfo.getObservableNameList().add((String)arrayList.get(i));
                    this.basicModelInfo.getObservableTypeList().add((Type)arrayList2.get(i));
                }
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(file) + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of " + string + "s file \"" + String.valueOf(file) + "\"");
        }
        catch (PrismException prismException) {
            throw new PrismException("Error detected (" + prismException.getMessage() + ") at line " + n + " of " + string + "s file \"" + String.valueOf(file) + "\"");
        }
    }

    private void extractModelStatsFromTransFile(File file) throws PrismException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            this.modelStats = new ModelStats();
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            if (!csvReader.hasNextRecord()) {
                throw new PrismException("empty transitions file");
            }
            String[] stringArray = csvReader.nextRecord();
            PrismExplicitImporter.checkLineSize(stringArray, 2, 4);
            this.modelStats.numStates = Integer.parseInt(stringArray[0]);
            if (stringArray.length == 2) {
                this.modelStats.numChoices = this.modelStats.numStates;
                this.modelStats.numTransitions = Integer.parseInt(stringArray[1]);
            } else if (stringArray.length == 3) {
                this.modelStats.numChoices = Integer.parseInt(stringArray[1]);
                this.modelStats.numTransitions = Integer.parseInt(stringArray[2]);
            } else {
                this.modelStats.numChoices = Integer.parseInt(stringArray[1]);
                this.modelStats.numTransitions = Integer.parseInt(stringArray[2]);
                this.modelStats.numObservations = Integer.parseInt(stringArray[3]);
            }
            if (csvReader.hasNextRecord() && (stringArray = csvReader.nextRecord()).length >= 1 && stringArray[0].equals("-")) {
                this.transFileStoresInitialStates = true;
            }
        }
        catch (IOException iOException) {
            this.modelStats = null;
            throw new PrismException("File I/O error reading from \"" + String.valueOf(file) + "\"");
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            this.modelStats = null;
            int n = 1;
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n + " of transitions file \"" + String.valueOf(file) + "\"");
        }
    }

    private void extractLabelNamesFromLabelsFile(File file) throws PrismException {
        int n = 1;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            Pattern pattern = Pattern.compile("(\\d+)=\"([^\"]+)\"\\s*");
            Matcher matcher = pattern.matcher(string);
            List<String> list = this.basicModelInfo.getLabelNameList();
            this.labelMap = new ArrayList<Integer>();
            while (matcher.find()) {
                int n2 = PrismExplicitImporter.checkLabelIndex(matcher.group(1));
                if (n2 != this.labelMap.size()) {
                    throw new PrismException("unexpected label index " + n2);
                }
                String string2 = matcher.group(2);
                if (string2.equals("init")) {
                    this.labelMap.add(-1);
                    continue;
                }
                if (string2.equals("deadlock")) {
                    this.labelMap.add(-2);
                    continue;
                }
                if (!ExpressionIdent.isLegalIdentifierName(string2)) {
                    throw new PrismException("illegal label name \"" + string2 + "\"");
                }
                if (list.contains(string2)) {
                    throw new PrismException("duplicate label name \"" + string2 + "\"");
                }
                this.labelMap.add(list.size());
                list.add(string2);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(file) + "\"");
        }
        catch (PrismException prismException) {
            String string = prismException.getMessage() == null || prismException.getMessage().isEmpty() ? "" : " (" + prismException.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n + " of labels file \"" + String.valueOf(file) + "\"");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelType autodetectModelType(File file) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            boolean bl;
            boolean bl2;
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            if (!csvReader.hasNextRecord()) {
                ModelType modelType = null;
                return modelType;
            }
            String[] stringArray = csvReader.nextRecord();
            if (stringArray.length == 4) {
                bl2 = true;
                bl = true;
            } else if (stringArray.length == 3) {
                bl2 = true;
                bl = false;
            } else {
                if (stringArray.length != 2) {
                    ModelType modelType = null;
                    return modelType;
                }
                bl2 = false;
                bl = false;
            }
            int n = 0;
            int n2 = 5;
            for (String[] stringArray2 : csvReader) {
                Object object;
                if (n > n2) break;
                if ("".equals(stringArray2[0]) || "-".equals(stringArray2[0])) continue;
                ++n;
                boolean bl3 = false;
                if (bl2) {
                    if (stringArray2.length == 3) {
                        bl3 = true;
                    } else if (stringArray2.length >= 4) {
                        bl3 = Prism.isValidIdentifier(stringArray2[3]);
                    }
                }
                if (bl3) {
                    object = ModelType.LTS;
                    return object;
                }
                if (bl2 && stringArray2.length >= 4) {
                    object = stringArray2[3];
                } else if (!bl2 && stringArray2.length >= 3) {
                    object = stringArray2[2];
                } else {
                    ModelType modelType = null;
                    return modelType;
                }
                if (((String)object).matches("\\[.+,.+\\]")) {
                    ModelType modelType = bl2 ? ModelType.IMDP : ModelType.IDTMC;
                    return modelType;
                }
                double d = ((String)object).matches("[0-9]+/[0-9]+") ? new BigRational((String)object).doubleValue() : Double.parseDouble((String)object);
                if (!(d > 1.0)) continue;
                ModelType modelType = ModelType.CTMC;
                return modelType;
            }
            Object object = bl2 ? (bl ? ModelType.POMDP : ModelType.MDP) : ModelType.DTMC;
            return object;
        }
        catch (CsvFormatException | IOException | NumberFormatException exception) {
            return null;
        }
    }

    private void findDeadlocks() throws PrismException {
        BitSet bitSet = new BitSet();
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                ++n;
                if ("".equals(stringArray[0]) || "-".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 3, 6);
                int n2 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), this.modelStats.numStates);
                bitSet.set(n2);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\": " + iOException.getMessage());
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
        this.deadlockInfo = new DeadlockInfo();
        if (bitSet.cardinality() != this.modelStats.numStates) {
            int n3 = bitSet.nextClearBit(0);
            while (n3 < this.modelStats.numStates) {
                this.deadlockInfo.deadlocks.set(n3);
                ++this.deadlockInfo.numDeadlocks;
                n3 = bitSet.nextClearBit(n3 + 1);
            }
        }
    }

    @Override
    public void extractStates(IOUtils.StateDefnConsumer stateDefnConsumer) throws PrismException {
        if (this.getStatesFile() == null) {
            super.extractStates(stateDefnConsumer);
            return;
        }
        this.extractStateDefinitions(this.statesFile, this.basicModelInfo.getNumVars(), stateDefnConsumer);
    }

    @Override
    public void extractObservationDefinitions(IOUtils.StateDefnConsumer stateDefnConsumer) throws PrismException {
        if (this.getObservationsFile() == null) {
            super.extractObservationDefinitions(stateDefnConsumer);
            return;
        }
        this.extractStateDefinitions(this.observationsFile, this.basicModelInfo.getNumObservables(), stateDefnConsumer);
    }

    private void extractStateDefinitions(File file, int n, IOUtils.StateDefnConsumer stateDefnConsumer) throws PrismException {
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            n2 += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            String string = bufferedReader.readLine();
            ++n2;
            while (string != null) {
                if (!(string = string.trim()).isEmpty()) {
                    String[] stringArray = string.split(":");
                    int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), this.modelStats.numStates);
                    stringArray = stringArray[1].substring(stringArray[1].indexOf(40) + 1, stringArray[1].indexOf(41)).split(",");
                    State state = new State(n);
                    if (stringArray.length != n) {
                        throw new PrismException("(wrong number of variable values) ");
                    }
                    for (int i = 0; i < n; ++i) {
                        if (stringArray[i].equals("true")) {
                            stateDefnConsumer.accept(n3, i, Boolean.TRUE);
                            continue;
                        }
                        if (stringArray[i].equals("false")) {
                            stateDefnConsumer.accept(n3, i, Boolean.FALSE);
                            continue;
                        }
                        stateDefnConsumer.accept(n3, i, Integer.parseInt(stringArray[i]));
                    }
                }
                string = bufferedReader.readLine();
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(file) + "\"");
        }
        catch (NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n2 + " of states file \"" + String.valueOf(file) + "\"");
        }
    }

    @Override
    public int computeMaxNumChoices() throws PrismException {
        int n = 0;
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                ++n;
                if ("".equals(stringArray[0]) || "-".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 3, 6);
                int n3 = PrismExplicitImporter.checkChoiceIndex(Integer.parseInt(stringArray[1]));
                if (n3 + 1 <= n2) continue;
                n2 = n3 + 1;
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\": " + iOException.getMessage());
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
        if (this.fixdl && this.getNumDeadlockStates() > 0) {
            n2 = Math.max(n2, 1);
        }
        return n2;
    }

    @Override
    public <Value> void extractMCTransitions(IOUtils.MCTransitionConsumer<Value> mCTransitionConsumer, Evaluator<Value> evaluator) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = -1;
        if (this.fixdl) {
            bitSet = this.getDeadlockStates();
            n = bitSet.nextSetBit(0);
        }
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n2 += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                String string;
                ++n2;
                if ("".equals(stringArray[0]) || "-".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 3, 4);
                int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), this.modelStats.numStates);
                int n4 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[1]), this.modelStats.numStates);
                Value Value2 = PrismExplicitImporter.checkValue(stringArray[2], evaluator);
                String string2 = string = stringArray.length > 3 ? PrismExplicitImporter.checkAction(stringArray[3]) : null;
                while (n != -1 && n < n3) {
                    mCTransitionConsumer.accept(n, n, evaluator.one(), null);
                    n = bitSet.nextSetBit(n + 1);
                }
                mCTransitionConsumer.accept(n3, n4, Value2, string);
            }
            while (n != -1) {
                mCTransitionConsumer.accept(n, n, evaluator.one(), null);
                n = bitSet.nextSetBit(n + 1);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\"");
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n2 + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
    }

    @Override
    public <Value> void extractMDPTransitions(IOUtils.MDPTransitionConsumer<Value> mDPTransitionConsumer, Evaluator<Value> evaluator) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = -1;
        if (this.fixdl) {
            bitSet = this.getDeadlockStates();
            n = bitSet.nextSetBit(0);
        }
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n2 += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                String string;
                ++n2;
                if ("".equals(stringArray[0]) || "-".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 4, 6);
                int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), this.modelStats.numStates);
                int n4 = PrismExplicitImporter.checkChoiceIndex(Integer.parseInt(stringArray[1]));
                int n5 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[2]), this.modelStats.numStates);
                Value Value2 = PrismExplicitImporter.checkValue(stringArray[3], evaluator);
                int n6 = this.getModelInfo().getModelType().partiallyObservable() ? 5 : 4;
                String string2 = string = stringArray.length > n6 ? PrismExplicitImporter.checkAction(stringArray[n6]) : null;
                while (n != -1 && n < n3) {
                    mDPTransitionConsumer.accept(n, 0, n, evaluator.one(), null);
                    n = bitSet.nextSetBit(n + 1);
                }
                mDPTransitionConsumer.accept(n3, n4, n5, Value2, string);
            }
            while (n != -1) {
                mDPTransitionConsumer.accept(n, 0, n, evaluator.one(), null);
                n = bitSet.nextSetBit(n + 1);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\"");
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n2 + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
    }

    @Override
    public void extractLTSTransitions(IOUtils.LTSTransitionConsumer lTSTransitionConsumer) throws PrismException {
        BitSet bitSet = new BitSet();
        int n = -1;
        if (this.fixdl) {
            bitSet = this.getDeadlockStates();
            n = bitSet.nextSetBit(0);
        }
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n2 += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                String string;
                ++n2;
                if ("".equals(stringArray[0]) || "-".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 3, 4);
                int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), this.modelStats.numStates);
                int n4 = PrismExplicitImporter.checkChoiceIndex(Integer.parseInt(stringArray[1]));
                int n5 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[2]), this.modelStats.numStates);
                String string2 = string = stringArray.length > 3 ? PrismExplicitImporter.checkAction(stringArray[3]) : null;
                while (n != -1 && n < n3) {
                    lTSTransitionConsumer.accept(n, 0, n, null);
                    n = bitSet.nextSetBit(n + 1);
                }
                lTSTransitionConsumer.accept(n3, n4, n5, string);
            }
            while (n != -1) {
                lTSTransitionConsumer.accept(n, 0, n, null);
                n = bitSet.nextSetBit(n + 1);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\"");
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n2 + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
    }

    @Override
    public void extractLabelsAndInitialStates(BiConsumer<Integer, Integer> biConsumer, Consumer<Integer> consumer, Consumer<Integer> consumer2) throws PrismException {
        BitSet bitSet = new BitSet();
        if (this.transFileProvidesInitialStates()) {
            this.extractInitialStatesFromTransFile(bitSet::set);
        }
        if (this.getLabelsFile() == null) {
            if (this.transFileProvidesInitialStates()) {
                int n = bitSet.nextSetBit(0);
                while (n >= 0) {
                    consumer.accept(n);
                    n = bitSet.nextSetBit(n + 1);
                }
            } else {
                consumer.accept(0);
            }
            return;
        }
        BitSet bitSet2 = new BitSet();
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.labelsFile));){
            n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!(string = string.trim()).isEmpty()) {
                    String[] stringArray = string.split(":");
                    int n2 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0].trim()), this.modelStats.numStates);
                    stringArray = stringArray[1].trim().split(" ");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].isEmpty()) continue;
                        int n3 = PrismExplicitImporter.checkLabelIndex(stringArray[i]);
                        int n4 = this.labelMap.get(n3);
                        if (n4 == -2) {
                            if (consumer2 == null) continue;
                            consumer2.accept(n2);
                            continue;
                        }
                        if (n4 == -1) {
                            bitSet2.set(n3);
                            continue;
                        }
                        if (n4 <= -1) continue;
                        biConsumer.accept(n2, n4);
                    }
                }
                string = bufferedReader.readLine();
            }
            if (this.transFileProvidesInitialStates() && !bitSet.equals(bitSet2)) {
                throw new PrismException("Inconsistent initial states information between transitions and labels files");
            }
            int n5 = bitSet2.nextSetBit(0);
            while (n5 >= 0) {
                consumer.accept(n5);
                n5 = bitSet2.nextSetBit(n5 + 1);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.labelsFile) + "\"");
        }
        catch (NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n + " of labels file \"" + String.valueOf(this.labelsFile) + "\"");
        }
    }

    @Override
    public void extractObservations(IOUtils.StateIntConsumer stateIntConsumer) throws PrismException {
        if (!this.getModelInfo().getModelType().partiallyObservable()) {
            return;
        }
        int[] nArray = new int[this.modelStats.numStates];
        Arrays.fill(nArray, -1);
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                ++n;
                if ("".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 5, 6);
                int n2 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[2]), this.modelStats.numStates);
                int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[4]), this.modelStats.numStates);
                if (nArray[n2] != -1 && nArray[n2] != n3) {
                    throw new PrismException("Conflicting observation information for state " + n2);
                }
                nArray[n2] = n3;
            }
            for (int i = 0; i < this.modelStats.numStates; ++i) {
                if (nArray[i] == -1) {
                    throw new PrismException("No observation information for state " + i);
                }
                stateIntConsumer.accept(i, nArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\"");
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
    }

    private void extractInitialStatesFromTransFile(Consumer<Integer> consumer) throws PrismException {
        ModelType modelType = this.getModelInfo().getModelType();
        int n = modelType.nondeterministic() ? 2 : 1;
        int n2 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.transFile));){
            n2 += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
            CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
            for (String[] stringArray : csvReader) {
                ++n2;
                if ("".equals(stringArray[0])) continue;
                PrismExplicitImporter.checkLineSize(stringArray, 3, 6);
                if (!"-".equals(stringArray[0])) {
                    break;
                }
                int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[n]), this.modelStats.numStates);
                consumer.accept(n3);
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(this.transFile) + "\"");
        }
        catch (CsvFormatException | NumberFormatException | PrismException exception) {
            String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
            throw new PrismException("Error detected" + string + " at line " + n2 + " of transitions file \"" + String.valueOf(this.transFile) + "\"");
        }
    }

    public Map<String, BitSet> extractAllLabels() throws PrismException {
        String[] stringArray;
        int n;
        if (this.getLabelsFile() == null) {
            throw new PrismException("No labels information available");
        }
        this.extractLabelNamesFromLabelsFile(this.labelsFile);
        BitSet[] bitSetArray = new BitSet[this.labelMap.size()];
        for (n = 0; n < bitSetArray.length; ++n) {
            bitSetArray[n] = new BitSet();
        }
        n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.labelsFile));
        try {
            int n2;
            int n3;
            String[] stringArray2;
            n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                if (!(string = string.trim()).isEmpty()) {
                    stringArray2 = string.split(":");
                    n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray2[0].trim()));
                    stringArray2 = stringArray2[1].trim().split(" ");
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        if (stringArray2[n2].isEmpty()) continue;
                        int n4 = PrismExplicitImporter.checkLabelIndex(stringArray2[n2]);
                        bitSetArray[n4].set(n3);
                    }
                }
                string = bufferedReader.readLine();
            }
            stringArray2 = new HashMap();
            for (n3 = 0; n3 < bitSetArray.length; ++n3) {
                n2 = this.labelMap.get(n3);
                if (n2 == -1) {
                    stringArray2.put("init", bitSetArray[n3]);
                    continue;
                }
                if (n2 == -2) {
                    stringArray2.put("deadlock", bitSetArray[n3]);
                    continue;
                }
                if (n2 <= -1) continue;
                stringArray2.put(this.basicModelInfo.getLabelNameList().get(n2), bitSetArray[n3]);
            }
            stringArray = stringArray2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + String.valueOf(this.labelsFile) + "\"");
            }
            catch (NumberFormatException | PrismException exception) {
                String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
                throw new PrismException("Error detected" + string + " at line " + n + " of labels file \"" + String.valueOf(this.labelsFile) + "\"");
            }
        }
        bufferedReader.close();
        return stringArray;
    }

    private void buildRewardInfo() throws PrismException {
        this.basicRewardInfo = new BasicRewardInfo();
        int n = Math.max(this.stateRewardsReaders.size(), this.transRewardsReaders.size());
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            if (i < this.stateRewardsReaders.size()) {
                string = this.stateRewardsReaders.get(i).getName().orElse("");
            }
            if (i < this.transRewardsReaders.size()) {
                string2 = this.transRewardsReaders.get(i).getName().orElse("");
            }
            if (string2 != null && string != null && !string2.equals(string)) {
                throw new PrismException("Reward structure names do not match for state/transition rewards");
            }
            this.basicRewardInfo.addReward(string != null ? string : string2);
            this.basicRewardInfo.setHasStateRewards(i, i < this.stateRewardsReaders.size());
            this.basicRewardInfo.setHasTransitionRewards(i, i < this.transRewardsReaders.size());
        }
    }

    @Override
    public <Value> void extractStateRewards(int n, BiConsumer<Integer, Value> biConsumer, Evaluator<Value> evaluator) throws PrismException {
        if (n < this.stateRewardsReaders.size()) {
            RewardFile rewardFile = this.stateRewardsReaders.get(n);
            rewardFile.extractStateRewards(biConsumer, evaluator);
        }
    }

    @Override
    public <Value> void extractMCTransitionRewards(int n, IOUtils.TransitionRewardConsumer<Value> transitionRewardConsumer, Evaluator<Value> evaluator) throws PrismException {
        if (n < this.transRewardsReaders.size()) {
            RewardFile rewardFile = this.transRewardsReaders.get(n);
            rewardFile.extractMCTransitionRewards(transitionRewardConsumer, evaluator);
        }
    }

    @Override
    public <Value> void extractMDPTransitionRewards(int n, IOUtils.TransitionRewardConsumer<Value> transitionRewardConsumer, Evaluator<Value> evaluator) throws PrismException {
        if (n < this.transRewardsReaders.size()) {
            RewardFile rewardFile = this.transRewardsReaders.get(n);
            rewardFile.extractMDPTransitionRewards(transitionRewardConsumer, evaluator);
        }
    }

    protected static int skipCommentAndFirstLine(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = 0;
        do {
            string = bufferedReader.readLine();
            ++n;
        } while (string != null && COMMENT_PATTERN.matcher(string).matches());
        return n;
    }

    protected static void checkLineSize(String[] stringArray, int n, int n2) throws PrismException {
        if (stringArray.length < n) {
            throw new PrismException("too few entries");
        }
        if (stringArray.length > n2) {
            throw new PrismException("too many entries");
        }
    }

    protected static void checkLineSize(String[] stringArray, int n) throws PrismException {
        if (stringArray.length < n) {
            throw new PrismException("too few entries");
        }
    }

    protected static int checkStateIndex(int n) throws PrismException {
        if (n < 0) {
            throw new PrismException("state index " + n + " is invalid");
        }
        return n;
    }

    protected static int checkStateIndex(int n, int n2) throws PrismException {
        if (n < 0) {
            throw new PrismException("state index " + n + " is invalid");
        }
        if (n > n2) {
            throw new PrismException("state index " + n + " exceeds number of states");
        }
        return n;
    }

    protected static int checkChoiceIndex(int n) throws PrismException {
        if (n < 0) {
            throw new PrismException("choice index " + n + " is invalid");
        }
        return n;
    }

    protected static int checkLabelIndex(String string) throws PrismException {
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                throw new PrismException("label index " + n + " is invalid");
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("label index \"" + string + "\" is invalid");
        }
    }

    protected static <Value> Value checkValue(String string, Evaluator<Value> evaluator) throws PrismException {
        try {
            return evaluator.fromString(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("invalid value \"" + string + "\"");
        }
    }

    protected static String checkAction(String string) throws PrismException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (!Prism.isValidIdentifier(string)) {
            throw new PrismException("invalid action name \"" + string + "\"");
        }
        return string;
    }

    protected static String checkRewardName(String string) throws PrismException {
        if (string == null) {
            throw new PrismException("missing reward name");
        }
        if (!Prism.isValidIdentifier(string)) {
            throw new PrismLangException("invalid reward name \"" + string + "\"");
        }
        return string;
    }

    private class ModelStats {
        int numStates = 0;
        int numChoices = 0;
        int numTransitions = 0;
        int numObservations = 0;

        private ModelStats() {
        }
    }

    public class RewardFile {
        protected final File file;
        protected final Optional<String> name;

        public RewardFile(File file) throws PrismException {
            this.file = Objects.requireNonNull(file);
            this.name = this.extractRewardStructureName(file);
        }

        public Optional<String> getName() {
            return this.name;
        }

        protected void extractStateRewards(BiConsumer<Integer, Double> biConsumer) throws PrismException {
            this.extractStateRewards(biConsumer, Evaluator.forDouble());
        }

        protected <Value> void extractStateRewards(BiConsumer<Integer, Value> biConsumer, Evaluator<Value> evaluator) throws PrismException {
            int n = 0;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
                n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
                ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
                CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
                for (String[] stringArray : csvReader) {
                    ++n;
                    if ("".equals(stringArray[0])) continue;
                    PrismExplicitImporter.checkLineSize(stringArray, 2, 2);
                    int n2 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), ((PrismExplicitImporter)PrismExplicitImporter.this).modelStats.numStates);
                    Value Value2 = PrismExplicitImporter.checkValue(stringArray[1], evaluator);
                    biConsumer.accept(n2, Value2);
                }
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + String.valueOf(this.file) + "\"");
            }
            catch (CsvFormatException | NumberFormatException | PrismException exception) {
                String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
                throw new PrismException("Error detected" + string + " at line " + n + " of state rewards file \"" + String.valueOf(this.file) + "\"");
            }
        }

        protected void extractMCTransitionRewards(IOUtils.TransitionRewardConsumer<Double> transitionRewardConsumer) throws PrismException {
            this.extractMCTransitionRewards(transitionRewardConsumer, Evaluator.forDouble());
        }

        protected <Value> void extractMCTransitionRewards(IOUtils.TransitionRewardConsumer<Value> transitionRewardConsumer, Evaluator<Value> evaluator) throws PrismException {
            if (PrismExplicitImporter.this.transitionRewardIndexing == ExplicitModelImporter.TransitionRewardIndexing.OFFSET && PrismExplicitImporter.this.modelLookup == null) {
                PrismExplicitImporter.this.modelLookup = new DTMCSimple();
                ((ModelExplicit)PrismExplicitImporter.this.modelLookup).setEvaluator(evaluator);
                ((ModelExplicit)PrismExplicitImporter.this.modelLookup).buildFromExplicitImport(PrismExplicitImporter.this);
            }
            int n = 0;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
                n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
                ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
                CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
                block12: for (String[] stringArray : csvReader) {
                    ++n;
                    if ("".equals(stringArray[0])) continue;
                    PrismExplicitImporter.checkLineSize(stringArray, 3, 3);
                    int n2 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), ((PrismExplicitImporter)PrismExplicitImporter.this).modelStats.numStates);
                    int n3 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[1]), ((PrismExplicitImporter)PrismExplicitImporter.this).modelStats.numStates);
                    Value Value2 = PrismExplicitImporter.checkValue(stringArray[2], evaluator);
                    switch (PrismExplicitImporter.this.transitionRewardIndexing) {
                        case STATE: {
                            transitionRewardConsumer.accept(n2, n3, Value2);
                            continue block12;
                        }
                        case OFFSET: {
                            SuccessorsIterator successorsIterator = PrismExplicitImporter.this.modelLookup.getSuccessors(n2);
                            int n4 = 0;
                            while (successorsIterator.hasNext()) {
                                if (successorsIterator.nextInt() == n3) {
                                    transitionRewardConsumer.accept(n2, n4, Value2);
                                    break;
                                }
                                ++n4;
                            }
                            if (n4 <= PrismExplicitImporter.this.modelLookup.getNumTransitions(n2)) continue block12;
                            throw new PrismException("No matching transition for transition reward " + n2 + "->" + n3);
                        }
                    }
                    throw new PrismException("Unknown transition reward indexing " + String.valueOf((Object)PrismExplicitImporter.this.transitionRewardIndexing));
                }
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + String.valueOf(this.file) + "\"");
            }
            catch (CsvFormatException | NumberFormatException | PrismException exception) {
                String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
                throw new PrismException("Error detected" + string + " at line " + n + " of transition rewards file \"" + String.valueOf(this.file) + "\"");
            }
        }

        protected void extractMDPTransitionRewards(IOUtils.TransitionRewardConsumer<Double> transitionRewardConsumer) throws PrismException {
            this.extractMDPTransitionRewards(transitionRewardConsumer, Evaluator.forDouble());
        }

        protected <Value> void extractMDPTransitionRewards(IOUtils.TransitionRewardConsumer<Value> transitionRewardConsumer, Evaluator<Value> evaluator) throws PrismException {
            int n = 0;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));){
                n += PrismExplicitImporter.skipCommentAndFirstLine(bufferedReader);
                ReplacingReader.ToChar toChar = BasicReader.wrap(bufferedReader).normalizeLineEndings();
                CsvReader csvReader = new CsvReader(toChar, false, false, false, 32, 10);
                int n2 = 0;
                int n3 = -1;
                int n4 = -1;
                Object Value2 = null;
                for (String[] stringArray : csvReader) {
                    ++n;
                    if ("".equals(stringArray[0])) continue;
                    PrismExplicitImporter.checkLineSize(stringArray, 4, 4);
                    int n5 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[0]), ((PrismExplicitImporter)PrismExplicitImporter.this).modelStats.numStates);
                    int n6 = PrismExplicitImporter.checkChoiceIndex(Integer.parseInt(stringArray[1]));
                    int n7 = PrismExplicitImporter.checkStateIndex(Integer.parseInt(stringArray[2]), ((PrismExplicitImporter)PrismExplicitImporter.this).modelStats.numStates);
                    Value Value3 = PrismExplicitImporter.checkValue(stringArray[3], evaluator);
                    if (n5 == n3 && n6 == n4) {
                        if (!evaluator.equals(Value2, Value3)) {
                            throw new PrismException("mismatching transition rewards " + String.valueOf(Value2) + " and " + String.valueOf(Value3) + " in choice " + n6 + " of state " + n5);
                        }
                    } else {
                        if (PrismExplicitImporter.this.modelLookup != null && PrismExplicitImporter.this.modelLookup instanceof NondetModel && n3 != -1 && n2 != ((NondetModel)PrismExplicitImporter.this.modelLookup).getNumTransitions(n3, n4)) {
                            throw new PrismException("wrong number of transition rewards in choice " + n4 + " of state " + n3);
                        }
                        n3 = n5;
                        n4 = n6;
                        Value2 = Value3;
                        n2 = 0;
                    }
                    if (n2 == 0) {
                        transitionRewardConsumer.accept(n5, n6, Value3);
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + String.valueOf(this.file) + "\"");
            }
            catch (CsvFormatException | NumberFormatException | PrismException exception) {
                String string = exception.getMessage() == null || exception.getMessage().isEmpty() ? "" : " (" + exception.getMessage() + ")";
                throw new PrismException("Error detected" + string + " at line " + n + " of transition rewards file \"" + String.valueOf(this.file) + "\"");
            }
        }

        protected Optional<String> extractRewardStructureName(File file) throws PrismException {
            int n = 0;
            Optional<String> optional = Optional.empty();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string = bufferedReader.readLine();
                while (string != null) {
                    ++n;
                    if (!COMMENT_PATTERN.matcher(string).matches()) {
                        break;
                    }
                    Matcher matcher = REWARD_NAME_PATTERN.matcher(string);
                    if (matcher.matches()) {
                        if (optional.isPresent()) {
                            throw new PrismException("multiple reward structure names");
                        }
                        optional = Optional.of(PrismExplicitImporter.checkRewardName(matcher.group(2)));
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("File I/O error reading from \"" + String.valueOf(this.file) + "\"");
            }
            catch (PrismException prismException) {
                String string = prismException.getMessage() == null || prismException.getMessage().isEmpty() ? "" : " (" + prismException.getMessage() + ")";
                throw new PrismException("Error detected" + string + " at line " + n + " of rewards file \"" + String.valueOf(this.file) + "\"");
            }
            return optional;
        }
    }

    private class DeadlockInfo {
        BitSet deadlocks = new BitSet();
        int numDeadlocks = 0;

        private DeadlockInfo() {
        }
    }
}

